package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 人脉
 *
 * @author carl
 * @date 2022/11/21
 */
public interface CrmPeopleService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmPeopleVO}
     */
    CrmPeopleVO insertOrUpdate(CrmPeoplePayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmPeopleVO queryByKey(Long key);

    /**
     * 修改爱心数量
     *
     * @param key
     * @param level
     * @return
     */
    void updateLoveLevel(Long key, Integer level);

    /**
     * 查询列表
     *
     * @return {@link List}<{@link CrmPeopleVO}>
     */
    List<CrmPeopleVO> queryList(Long operId);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmPeopleVO> paging(CrmPeopleQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys, String type);

    /**
     * 删除客户经营人脉
     *
     * @param operIds
     */
    void deleteSoftByOperIds(List<Long> operIds);

    /**
     * 查询人脉列表
     *
     * @param key       人脉主键
     * @param searchStr 模糊查询字段
     * @param type      查询类型
     * @return
     */
    List<CrmPeopleVO> queryRefPeopleList(Long key, String searchStr, String type);

    /**
     * 查询人脉下面的经营往来
     *
     * @param peopleId
     * @return
     */
    List<CrmFollowVO> queryOperateFollowList(Long peopleId);

    /**
     * 关联客户
     *
     * @param operId
     * @param customerId
     */
    void relationCustomer(Long operId, Long customerId);

    /**
     * 分页查询业务往来
     *
     * @param query 查询参数
     * @return 分页结果
     */
    Object queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query);

    /**
     * 查询日志列表
     *
     * @param id id
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long id);

    /**
     * 查询人脉概览
     *
     * @param peopleId
     * @return
     */
    Object queryPeopleView(Long peopleId);

    /**
     * 查询人脉相关经营计划
     *
     * @param peopleId
     * @return
     */
    List<CrmOperationPlanDetailVO> queryOperationPlanDetailList(Long peopleId);

    /**
     * 批量下载
     *
     * @param response
     * @param query
     */
    void downloadBatch(HttpServletResponse response, CrmPeopleQuery query);

    /**
     * 获取我拥有权限的的客户经营ids
     *
     * @param userId
     * @return
     */
    List<Long> queryPermitOperationIds(Long userId);
}
