package com.elitesland.tw.tw5.api.prd.org.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class PrdOrgCompanyNoticePayload extends TwCommonPayload {
    /**
     * 公告标题
     */
    @ApiModelProperty("公告标题")
    private String noticeTitle;

    /**
     * 公告作者
     */
    @ApiModelProperty("公告作者")
    private String noticeAuthor;

    /**
     * 公告作者
     */
    @ApiModelProperty("公告作者")
    private String noticeAuthorUserId;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private Integer sort;

    /**
     * 更新时间
     */
    @ApiModelProperty("更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeTime;

    /**
     * 阅览量
     */
    @ApiModelProperty("阅览量")
    private Long readAmount;

    /**
     * 置顶标志
     */
    @ApiModelProperty("置顶标志")
    private Integer topFlag;

    /**
     * 公告内容
     */
    @ApiModelProperty("公告内容")
    private String noticeContent;

    /**
     * 公告摘要
     */
    @ApiModelProperty("公告摘要")
    private String noticeAbstract;


    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCodes;

    /**
     * 发布标志
     */
    @ApiModelProperty("发布标志")
    private Integer publishFlag;

    /**
     * 公告类型,正常类型：NORMAL,活动：ACTIVITY
     */
    @ApiModelProperty("公告类型")
    private String noticeType;

    /**
     * 资源id 正常:为null，活动：活动id
     */
    @ApiModelProperty("资源id")
    private String sourceId;
    /**
     * 定时发布（触发时间表达式）
     */
    @ApiModelProperty("触发时间表达式")
    private String triggerTimeExpression;
}
