package com.elitesland.tw.tw5.api.prd.sale.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 合同
 *
 * @author duwh
 * @date 2022/09/27
 */
@Data
public class SaleContractQuery extends TwQueryParam {

    /**
     * 模板主键
     */
    @Query()
    private Long tempId;

    /**
     * 标签id
     */
    @Query()
    private Long tagId;

    /**
     * 合同名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String contractName;

    /**
     * 合同编号
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String contractNo;

    /**
     * 合同金额
     */
    private BigDecimal amt;

    /**
     * 合同状态
     */
    @Query()
    private String contractStatus;

    /**
     * 合同描述
     */
    private String contractDesc;

    /**
     * 流程实例ID
     */
    @Query()
    private String procInstId;

    /**
     * 流程审批状态
     */
    @Query()
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;


}
