package com.elitesland.tw.tw5.api.prd.shorturl.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 短链服务请求记录
 *
 * @author duwh
 * @date 2023-05-19
 */
@Getter
@Setter
public class ShortUrlRequestLogPayload extends TwCommonPayload  implements Serializable {
    /** prd_short_url.id */
    @ApiModelProperty("prd_short_url.id")
    private Long shortId;
    /** 短链地址 */
    @ApiModelProperty("短链地址")
    private String shortUrl;
    /** 长链地址 */
    @ApiModelProperty("长链地址")
    private String longUrl;
    /** 参数 */
    @ApiModelProperty("参数")
    private String params;
    /** ip来源 */
    @ApiModelProperty("ip来源")
    private String requestIp;
    /** 耗时 */
    @ApiModelProperty("耗时")
    private Long time;
    /** 请求所属地址 */
    @ApiModelProperty("请求所属地址")
    private String address;
    /** 浏览器 */
    @ApiModelProperty("浏览器")
    private String browser;
    /** 拓展1 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
