package com.elitesland.tw.tw5.api.common.change.service;


import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;

import java.util.List;
import java.util.Map;

/**
 * @author liwenpeng
 * @date 2021/9/27 15:17
 */
public interface PrdSystemBusinessChangeService {


    /**
     * 保存原始版本
     *
     * @param changeType        变更类型
     * @param versionContent    原始数据
     * @param parentChangeType  关联父级变更类型
     * @param parentChangeDocId 关联父级单据id
     * @param activeFlag        是否立即激活（在走完新增流程后，保存基本版本是，activeFlag直接传1）
     * @return
     */
    Long saveNewLog(String changeType, BaseViewModel versionContent, String parentChangeType, String parentChangeDocId, Integer activeFlag);


    /**
     * 根据id变更版本内容
     *
     * @param logId
     * @param baseViewModel
     */
    void updateVersionContent(Long logId, BaseViewModel baseViewModel);

//    /**
//     * 更新原始版本（针对字段更新或局部字段更新的情况）
//     * @param changeType 变更类型
//     * @param changePayload 原始数据
//     * @return
//     */
//    Long updateNewLog(String changeType, TwCommonPayload changePayload);

//    /**
//     * 删除一条原始版本
//     * @param changeType 变更类型
//     * @param changeDocId 单据id
//     * @return
//     */
//    Long deleteNewLog(String changeType, String changeDocId);


    /**
     * 保存一个变更版本
     *
     * @param changeType        变更类型
     * @param changePayload     本次更新的数据
     * @param parentChangeType  关联父级变更类型
     * @param parentChangeDocId 关联父级单据id
     */
    Long saveVersionLog(String changeType, TwCommonPayload changePayload, String parentChangeType, String parentChangeDocId);


//    /**
//     * 按条件判断进行版本变更，此方法不适用于无初始版本数据的调用
//     * @param changeType
//     * @param changePayload
//     * @param parentChangeType
//     * @param parentChangeDocId
//     */
//    void updateByVersionCondition(String changeType, String changeDocId,TwCommonPayload changePayload,String parentChangeType,String parentChangeDocId);

    /**
     * 删除当前版本
     *
     * @param changeType 变更类型
     * @param docId      单据id
     * @return
     */
    void deleteCurrentVersionLog(String changeType, String docId);


    List<PrdSystemBusinessChangeVO> getChangeLogChildrenLogs(String parentChangeType, String parentDocId, Integer currentVersion);

    /**
     * 激活当前版本
     *
     * @param changeType 变更类型
     * @param docId      单据id
     */
    Map<String, Object> activeCurrentVersionLog(String changeType, String docId);


    /**
     * 查询当前未激活版本的版本号
     *
     * @param changeType
     * @param docId
     * @return
     */
    Integer getCurrentVersion(String changeType, String docId);

    Long getCurrentVersionId(String changeType, String docId);

    Integer getCurrentActiveVersion(String changeType, String docId);


    Integer getInitVersion(String changeType, String docId);


    /**
     * 查询变更日志列表
     *
     * @param changeType
     * @param docId
     * @return
     */
    List<PrdSystemBusinessChangeVO> getChangeLogList(String changeType, String docId);


    /**
     * 查询变更日志详情(针对主表)
     *
     * @param id
     * @return
     */
    Map<String, Object> getChangeLogDetail(Long id, Long compareLogId);

    /**
     * 删除变更对象
     *
     * @param changeLogId
     */
    void deleteById(Long changeLogId);

    /**
     * 根据id查询
     *
     * @param changeLogId
     */
    PrdSystemBusinessChangeVO mergeVersionByCurrentDocId(Long changeLogId);


//    /**
//      * 通用变更数据更新
//      * @param changeType 变更类型
//      * @param changeModel 变更数据
//      * @return
//      */
//     Long update(String changeType,TwCommonPayload changeModel);
//
////    /**
////     * 通用变更数据删除(删除列表里的一条记录的场景)
////     * @param changeType 变更类型
////     * @param changeModel 变更数据
////     * @return
////     */
////    Long deleteFromList(String changeType,TwCommonPayload changeModel);
//
//
//
//     /**
//      * 变更流程中 对比和原数据的差异
//      * @param changeType
//      * @param originalModel
//      * @return
//      */
////     Map<String,Object> detail(String changeType, BaseModel originalModel);
//
//     /**
//      * 变更流程结束 读取变更数据 用以保存
//      * @param changeType
//      * @param docId
//      * @return
//      */
//     String reverseSave(String changeType,Long docId);
//
//     /**
//      * 变更流程作废 删除变更数据
//      * @param changeType
//      * @param docId
//      * @return
//      */
//     Long delete(String changeType,Long docId);
//
//     /**
//      * 根据变更类型和数据id 获得当前变更最新记录
//      * @param changeType
//      * @param docId
//      * @return
//      */
//     PrdSystemBusinessChangeVO findChangeDoByChangeTypeAndDocId(String changeType, Long docId);
//
//    /**
//     * 查询用父单据做为docId的当前类型的所有原始值为null的单据
//     * @param changeType
//     * @param docId
//     * @return
//     */
//     List<PrdSystemBusinessChangeVO> findChangeDosByChangeTypeAndSuperDocId(String changeType, Long docId);
//
//     /**
//      * 条件查询 变更历史
//      * @param query 条件查询对象
//      * @return 分页包装其他费用
//      */
//     PagingVO<PrdSystemBusinessChangeVO> changeSearch(PrdSystemBusinessChangeQuery query);
//
//
//    /**
//     * 更新变更对象
//     * @param changePayload
//     * @return
//     */
//    Long updateBusinessChange(PrdSystemBusinessChangePayload changePayload);
//
//    /**
//     * 对比数据与原数据的差异
//     * @param id 变更记录的id
//     * @param cla 表单对象的类型
//     * @param t 表单对象
//     * @param <T>
//     * @return
//     */
//    <T extends TwCommonPayload> Map<String,Object> compareDetail(Long id, Class<T> cla,T t);
//
//    /**
//     * 删除变更对象
//     * @param docId
//     */
//    void deleteById(Long docId);
//
//
//    PrdSystemBusinessChangePayload findOneById(Long id);


    /**
     * 暂存变更内容
     *
     * @param changeType 变更类型
     * @param payload    变更数据
     * @param activeFlag 是否立即激活（在走完新增流程后，保存基本版本是，activeFlag直接传1）
     * @return
     */
    Long saveChangeLog(String changeType, TwCommonPayload payload, Integer activeFlag);

    Map<String, Object> getCurrentVersionLog(String changeType, String docId);

    /**
     * 更新变更内容
     *
     * @param changeType     变更类型
     * @param versionContent 历史数据
     * @param versionContent 变更数据
     * @param docId          单据
     * @return
     */
    void updateVersionLog(Object versionContent, Object changeContent, String changeType, String docId);

    void save(PrdSystemBusinessChangePayload payload);

    void updateVersionStatus(String changeType, String docId, Integer versionStatus);

    PrdSystemBusinessChangeVO getChangeLog(String changeType, String docId, String procInstId);

}
