package com.elitesland.tw.tw5.api.common.funConfig.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;

/**
 * 文档配置函数表达式
 *
 * @author wangly
 * @date 2024-07-02
 */
@Getter
@Setter
public class BusinessDocTypeConfigPathExprPayload extends TwCommonPayload  implements Serializable {
    /** 函数ID */
    @ApiModelProperty("函数ID")
    private Long functionId;
    /**
     * 易稻壳libraryId(文档库id)
     */
    @ApiModelProperty("易稻壳libraryId(文档库id)")
    private String libraryId;
    /**
     * 易稻壳libraryId翻译
     */
    @ApiModelProperty("易稻壳libraryId翻译")
    private String libraryName;
    /** 路径 */
    @ApiModelProperty("路径")
    private String exprValue;
    /** 路径映射 */
    @ApiModelProperty("路径映射")
    private String exprValueDesc;
    /** 数据库表名 prd_business_table.table_name */
    @ApiModelProperty("数据库表名 prd_business_table.table_name")
    private String tableName;
    /** 数据库表名 prd_business_table.name */
    @ApiModelProperty("数据库表名 prd_business_table.name")
    private String tableNameDesc;
    /** 业务对象字段明细主键 prd_business_table_fields.fieldid */
    @ApiModelProperty("业务对象字段明细主键 prd_business_table_fields.field")
    private String field;
    /** 字段展示名称 prd_business_table_fields.show_name */
    @ApiModelProperty("字段展示名称 prd_business_table_fields.show_name")
    private String fieldShowName;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;

    /** 业务对象字段明细主键 prd_business_table_fields.fieldid */
    @ApiModelProperty("业务对象字段明细主键 prd_business_table_fields.fieldid")
    private Long fieldId;

    /** 业务对象字段明细业务类型 */
    @ApiModelProperty("业务对象字段明细业务类型")
    private String showType;
}
