package com.elitesland.tw.tw5.api.common.funConfig.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Getter
@Setter
public class BusinessDocTypeConfigQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private Long idNe;
    /** 名称 精确 */
    @ApiModelProperty("名称")
    private String name;
    /** 编码 精确 */
    @ApiModelProperty("编码")
    private String code;
    /** 功能主键 prd_system_function.id 精确 */
    @ApiModelProperty("功能主键 prd_system_function.id")
    private Long functionId;
    /** 业务对象主键 prd_business_table.id 精确 */
    @ApiModelProperty("业务对象主键 prd_business_table.id")
    private Long tableId;
    /** 数据库表名 prd_business_table.table_name 精确 */
    @ApiModelProperty("数据库表名 prd_business_table.table_name")
    private String tableName;
    /** 业务对象字段明细主键 prd_business_table_fields.id 精确 */
    @ApiModelProperty("业务对象字段明细主键 prd_business_table_fields.id")
    private Long fieldId;
    /** 字段展示名称 prd_business_table_fields.show_name 精确 */
    @ApiModelProperty("字段展示名称 prd_business_table_fields.show_name")
    private String fieldShowName;
    /** 是否启用 精确 */
    @ApiModelProperty("是否启用")
    private Boolean enabled;
    /**
     * 权限控制标志
     */
    @ApiModelProperty("是否需要权限控制")
    private Boolean permissionControlFlag;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
