package com.elitesland.tw.tw5.api.common.funConfig.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Getter
@Setter
public class BusinessDocTypeConfigRuleQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private Long idNe;
    /** 文档类型配置主键 prd_business_doc_type_config.id 精确 */
    @ApiModelProperty("文档类型配置主键 prd_business_doc_type_config.id")
    private Long configId;
    /** 条件 =、 in、not in、..... 精确 */
    @ApiModelProperty("条件 =、 in、not in、.....")
    private String conditions;
    /** 条件值 精确 */
    @ApiModelProperty("条件值")
    private String conditionsValue;
    /** 易道壳itemId 精确 */
    @ApiModelProperty("易道壳itemId")
    private String itemId;
    /** 易稻壳libraryId 精确 */
    @ApiModelProperty("易稻壳libraryId")
    private String libraryId;
    /** 易稻壳libraryId翻译 精确 */
    @ApiModelProperty("易稻壳libraryId翻译")
    private String libraryName;
    /** 易稻壳库下的文件路径 /A/B/C 精确 */
    @ApiModelProperty("易稻壳库下的文件路径 /A/B/C")
    private String path;
    /** 文档类型名称（冗余）prd_business_doc_type_config.name 精确 */
    @ApiModelProperty("文档类型名称（冗余）prd_business_doc_type_config.name")
    private String configName;
    /** 文档类型编码（冗余）prd_business_doc_type_config.code 精确 */
    @ApiModelProperty("文档类型编码（冗余）prd_business_doc_type_config.code")
    private String configCode;
    /** 功能主键(冗余) prd_system_function.id 精确 */
    @ApiModelProperty("功能主键(冗余) prd_system_function.id")
    private Long functionId;
    /** 业务对象主键(冗余) prd_business_table.id 精确 */
    @ApiModelProperty("业务对象主键(冗余) prd_business_table.id")
    private Long tableId;
    /** 数据库表名(冗余) prd_business_table.table_name 精确 */
    @ApiModelProperty("数据库表名(冗余) prd_business_table.table_name")
    private String tableName;
    /** 业务对象字段明细主键(冗余) prd_business_table_fields.id 精确 */
    @ApiModelProperty("业务对象字段明细主键(冗余) prd_business_table_fields.id")
    private Long fieldId;
    /** 字段展示名称(冗余) prd_business_table_fields.show_name 精确 */
    @ApiModelProperty("字段展示名称(冗余) prd_business_table_fields.show_name")
    private String fieldShowName;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
