package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRulePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRuleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRuleVO;

import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
public interface BusinessDocTypeConfigRuleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeConfigRuleVO}>
     */
    PagingVO<BusinessDocTypeConfigRuleVO> queryPaging(BusinessDocTypeConfigRuleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeConfigRuleVO}>
     */
    List<BusinessDocTypeConfigRuleVO> queryListDynamic(BusinessDocTypeConfigRuleQuery query);

    Long count(BusinessDocTypeConfigRuleQuery query);

    Long checkUnique(Long configId);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeConfigRuleVO}
     */
    BusinessDocTypeConfigRuleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigRuleVO}
     */
    BusinessDocTypeConfigRuleVO insert(BusinessDocTypeConfigRulePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigRuleVO}
     */
    BusinessDocTypeConfigRuleVO update(BusinessDocTypeConfigRulePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeConfigRulePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
