package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypePermissionPrevRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypePermissionPrevRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;

import java.util.List;

/**
 * 通用文档-易稻壳赋权预览地址获取记录表
 *
 * @author duwh
 * @date 2023-12-09
 */
public interface BusinessDocTypePermissionPrevRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypePermissionPrevRecordVO}>
     */
    PagingVO<BusinessDocTypePermissionPrevRecordVO> queryPaging(BusinessDocTypePermissionPrevRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypePermissionPrevRecordVO}>
     */
    List<BusinessDocTypePermissionPrevRecordVO> queryListDynamic(BusinessDocTypePermissionPrevRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    BusinessDocTypePermissionPrevRecordVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    BusinessDocTypePermissionPrevRecordVO insert(BusinessDocTypePermissionPrevRecordPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    BusinessDocTypePermissionPrevRecordVO update(BusinessDocTypePermissionPrevRecordPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypePermissionPrevRecordPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
