package com.elitesland.tw.tw5.api.common.util;

import cn.hutool.core.lang.Assert;
import com.zaxxer.hikari.HikariDataSource;
import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Component
@RequiredArgsConstructor
public class DataSourceUtil {

    private final static Logger logger = LoggerFactory.getLogger(DataSourceUtil.class);

    private final DataSourceProperties dataSourceProperties;

    public DataSource getDs() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(Assert.notBlank(dataSourceProperties.getUrl(), "dataHub的数据库url为空"));
        ds.setDriverClassName(Assert.notBlank(dataSourceProperties.getDriverClassName(), "dataHub的数据库驱动为空"));
        ds.setUsername(Assert.notBlank(dataSourceProperties.getUsername(), "dataHub的数据库用户名为空"));
        ds.setPassword(Assert.notBlank(dataSourceProperties.getPassword(), "dataHub的数据库密码为空"));
        ds.setAutoCommit(false);
        return ds;
    }
}
