package com.elitesland.tw.tw5.api.demo.service;

import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.query.DemoSimpleQuery;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 简单demo service
 *
 * @author zhangyongqiang
 */
public interface DemoSimpleService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    DemoSimpleVO insert(DemoSimplePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    DemoSimpleVO update(DemoSimplePayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    DemoSimpleVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<DemoSimpleVO> paging(DemoSimpleQuery query);

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 结果列表
     */
    List<DemoSimpleVO> queryList(DemoSimpleQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
}
