package com.elitesland.tw.tw5.api.prd.ab.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

/**
 * @author carl.wang
 * @Description:账户管理
 */

@Data
public class PrdAbAccountPayload extends TwCommonPayload {
    /**
     * 地址簿id (业务伙伴取得是5.0的book_id)
     */
    private Long bookId;
    /**
     * 账户类型 udc无需翻译
     */
    private String accountType;
    /**
     * 银行
     */
    private String depositBank;
    /**
     * 开户地
     */
    private String depositCity;
    /**
     * 开户网点
     */
    private String depositBankOutlet;
    /**
     * 户名
     */
    private String accountName;
    /**
     * 账号
     */
    private String accountNo;
    /**
     * 币种
     */
    private String currency;
    /**
     * 默认
     */
    private Boolean defaultFlag;

    /**
     * 主档类型（客户，供应商，合作伙伴，内部公司）
     */
    private String objectType;
}
