package com.elitesland.tw.tw5.api.prd.ab.service;


import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAccountVO;

import java.util.List;

/**
 * @author carl.wang
 * @Description: 银行账户管理
 * @date
 */
public interface PrdAbAccountService {
    /**
     * @param payload
     * @Description 新增地址簿和公司
     **/
    PrdAbAccountVO save(PrdAbAccountPayload payload);

    /**
     * @param keys       主键
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @return
     * @Description 删除
     **/
    boolean delete(Long bookId, String objectType, List<Long> keys);

    /**
     * @param payload
     * @Description 修改地址簿和公司
     **/
    boolean update(PrdAbAccountPayload payload);

    /**
     * @return
     * @Description 列表查询
     **/
    List<PrdAbAccountVO> queryList(Long bookId);

    List<PrdAbAccountVO> selectInternalOu();


    /**
     * 查询列表
     *
     * @param bookId      地址簿主键
     * @param accountType 帐户类型
     * @param defaultFlag 默认
     * @param accountNo   账号
     * @return {@link List}<{@link PrdAbAccountVO}>
     */
    List<PrdAbAccountVO> queryList(Long bookId, String accountType, Boolean defaultFlag, String accountNo);
}
