package com.elitesland.tw.tw5.api.prd.ab.service;


import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAddressPayload;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAddressVO;

import java.util.List;

/**
 * @author carl.wang
 * @Description: 地址管理
 * @date
 */
public interface PrdAbAddressService {
    /**
     * @param payload
     * @Description 新增地址簿和公司
     **/
    PrdAbAddressVO save(PrdAbAddressPayload payload);

    /**
     * @param keys       主键
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @return
     * @Description 删除
     **/
    boolean delete(Long bookId, String objectType, List<Long> keys);

    /**
     * @param payload
     * @Description 修改地址簿和公司
     **/
    boolean update(PrdAbAddressPayload payload);

    /**
     * @return
     * @Description 列表查询
     **/
    List<PrdAbAddressVO> queryList(Long bookId);

    List<PrdAbAddressVO> queryList(Long bookId, String addressType);
}
