package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 核算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccBusinessItemPayload extends TwCommonPayload implements Serializable {
    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    private String businessCode;
    /**
     * 预算名称
     */
    @ApiModelProperty("预算名称")
    private String businessName;
    /**
     * 上级id
     */
    @ApiModelProperty("上级id")
    private Long parentId;
    /**
     * 上级编号
     */
    @ApiModelProperty("上级编号")
    private String parentCode;
    /**
     * 上级科目名称
     */
    @ApiModelProperty("上级科目名称")
    private String parentName;
    /**
     * 汇总科目（0：否，1：是）
     */
    @ApiModelProperty("汇总科目（0：否，1：是）")
    private Integer sumFlag;
    /**
     * 明细账
     */
    @ApiModelProperty("明细账")
    private String dtlAcc;
    /**
     * 处理码
     */
    @ApiModelProperty("处理码")
    private String procCode;
    /**
     * 子账标记
     */
    @ApiModelProperty("子账标记")
    private Integer ledgerFlag;
    /**
     * 子账类型
     */
    @ApiModelProperty("子账类型")
    private String ledgerType;
    /**
     * 可配置字段1
     */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /**
     * 可配置字段2
     */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /**
     * 可配置字段3
     */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /**
     * 可配置字段4
     */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /**
     * 可配置字段5
     */
    @ApiModelProperty("可配置字段5")
    private String extStr5;
    /**
     * 核算项目类别
     */
    @ApiModelProperty("核算项目类别")
    private String businessType;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String businessStatus;
    /**
     * 级别
     */
    @ApiModelProperty("级别")
    private Integer businessLevel;
    /**
     * 大类
     */
    @ApiModelProperty("大类")
    private String businessType1;
    /**
     * 明细类1
     */
    @ApiModelProperty("明细类1")
    private String businessType2;
    /**
     * 明细类2
     */
    @ApiModelProperty("明细类2")
    private String businessType3;

    /**
     * 税率
     */
    @ApiModelProperty("税率（报销时用）")
    private BigDecimal taxRate;
}
