package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 会计科目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccFinancialSubjectPayload extends TwCommonPayload implements Serializable {
    /**
     * 科目编号
     */
    @ApiModelProperty("科目编号")
    private String accCode;
    /**
     * 上级科目主键
     */
    @ApiModelProperty("上级科目主键")
    private Long parentId;
    /**
     * 上级科目编号
     */
    @ApiModelProperty("上级科目编号")
    private String upperCode;
    /**
     * 上级科目名称
     */
    @ApiModelProperty("上级科目名称")
    private String upperName;
    /**
     * 科目行业
     */
    @ApiModelProperty("科目行业")
    private String accIndustrys;
    /**
     * 科目名称
     */
    @ApiModelProperty("科目名称")
    private String accName;
    /**
     * 科目简称
     */
    @ApiModelProperty("科目简称")
    private String accAbbr;
    /**
     * 科目状态
     */
    @ApiModelProperty("科目状态")
    private String accStatus;
    /**
     * 科目级别
     */
    @ApiModelProperty("科目级别")
    private Integer accLevel;
    /**
     * 汇总科目（0：否，1：是）
     */
    @ApiModelProperty("汇总科目（0：否，1：是）")
    private Integer sumFlag;
    /**
     * 明细账
     */
    @ApiModelProperty("明细账")
    private String dtlAcc;
    /**
     * 处理码
     */
    @ApiModelProperty("处理码")
    private String procCode;
    /**
     * 子账标记
     */
    @ApiModelProperty("子账标记")
    private Integer ledgerFlag;
    /**
     * 子账类型
     */
    @ApiModelProperty("子账类型")
    private String ledgerType;
    /**
     * 大类
     */
    @ApiModelProperty("大类")
    private String accType1;
    /**
     * 明细类1
     */
    @ApiModelProperty("明细类1")
    private String accType2;
    /**
     * 明细类2
     */
    @ApiModelProperty("明细类2")
    private String accType3;
    /**
     * 类别1
     */
    @ApiModelProperty("类别1")
    private String accCat1;
    /**
     * 类别2
     */
    @ApiModelProperty("类别2")
    private String accCat2;
    /**
     * 类别3
     */
    @ApiModelProperty("类别3")
    private String accCat3;
    /**
     * 类别4
     */
    @ApiModelProperty("类别4")
    private String accCat4;
    /**
     * 类别5
     */
    @ApiModelProperty("类别5")
    private String accCat5;
    /**
     * 账套名称
     */
    @ApiModelProperty("账套名称")
    private String accsetName;
    /**
     * 借贷类型
     */
    @ApiModelProperty("借贷类型")
    private String drcrType;
}
