package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 报销明细餐费记录
 *
 * @author zoey
 * @date 2024-06-12
 */
@Getter
@Setter
public class AccReimDetailMealPayload extends TwCommonPayload implements Serializable {
    /**
     * 报销单明细ID
     */
    @ApiModelProperty("报销单明细ID")
    private Long reimDetailId;
    /**
     * 打卡记录id
     */
    @ApiModelProperty("打卡记录id")
    private Long attendanceId;
//    /**
//     * 法定假期id
//     */
//    @ApiModelProperty("法定假期id")
//    private Integer vacationId;
    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCode;
    /**
     * 餐费日期
     */
    @ApiModelProperty("餐费日期")
    private LocalDate mealDate;

    /**
     * 餐费
     */
    @ApiModelProperty("餐费")
    private BigDecimal mealAmt;

    /**
     * 打卡城市
     */
    private String attendanceCity;
}
