package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 报销规则管理
 *
 * @author sunxw
 * @date 2023-12-03
 */
@Getter
@Setter
public class AccReimRulePayload extends TwCommonPayload implements Serializable {
    /**
     * 规则编号
     */
    @ApiModelProperty("规则编号")
    private String ruleNo;
    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String ruleName;
    /**
     * 核算项目(对多个生效时，可以,分割)
     */
    @ApiModelProperty("核算项目编码(对多个生效时，可以,分割)")
    private String busAccItemCodes;
    /**
     * 费用发生日期
     */
    @ApiModelProperty("费用发生日期")
    private LocalDate expenseDate;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private LocalDate invDate;
    /**
     * 额度控制
     */
    @ApiModelProperty("额度控制")
    private BigDecimal limitAmt;
    /**
     * 规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致)
     */
    @ApiModelProperty("规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致)")
    private String ruleType;
    /**
     * 检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条
     */
    @ApiModelProperty("检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条")
    private String checkRange;
    /**
     * 是否支持动态配置 0-否 1-是
     */
    @ApiModelProperty("是否支持动态配置 0-否 1-是")
    private Integer dynamicFlag;
    /**
     * 规则开关标识 0-关闭 1-开启
     */
    @ApiModelProperty("规则开关标识 0-关闭 1-开启 ")
    private Integer ruleFlag;
    /**
     * 规则提示信息
     */
    @ApiModelProperty("规则提示信息")
    private String noticeMsg;
    /**
     * 规则提示登记 WARN-存在警告 ILLEGAL-不符合规范
     */
    @ApiModelProperty("规则提示登记 WARN-存在警告 ILLEGAL-不符合规范")
    private String noticeLevel;
    /**
     * 扩展字段1 作为出发地
     */
    @ApiModelProperty("扩展字段1 作为出发地")
    private String extString1;
    /**
     * 扩展字段2 作为目的地
     */
    @ApiModelProperty("扩展字段2 作为目的地")
    private String extString2;
    /**
     * 扩展字段3 作为日期起
     */
    @ApiModelProperty("扩展字段3 作为日期起")
    private String extString3;
    /**
     * 扩展字段4 作为日期止
     */
    @ApiModelProperty("扩展字段4 作为日期止")
    private String extString4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5 作为月份大小")
    private String extString5;
}
