package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Getter
@Setter
public class AccReimSettingCheckPayload extends TwCommonPayload  implements Serializable {

    /**
     * 报销人id
     */
    private Long reimUserId;

    /** 规则id */
    @ApiModelProperty("规则id")
    private Map<String,Long> keys;

    /** 报销金额 */
    @ApiModelProperty("报销金额")
    private BigDecimal reimAmt;

    /** 费用发生地城市级别 */
    @ApiModelProperty("费用发生地城市级别")
    private String expensePlaceGrade;

    /**
     * 费用发生日期
     */
    @ApiModelProperty("费用发生日期")
    private String expenseDate;

    /**
     * 发票号码
     */
    @ApiModelProperty("发票号码")
    private String invoiceNo;

    /**
     * 费用承担公司id
     */
    @ApiModelProperty("费用承担公司id")
    private Long expenseCompanyId;
}
