package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;

/**
 * 报销配置连号规则配置
 *
 * @author zoey
 * @date 2024-04-16
 */
@Getter
@Setter
public class AccReimSettingContinuousPayload extends TwCommonPayload  implements Serializable {
    /** 发票类型 */
    @ApiModelProperty("发票类型")
    private String invoiceType;
    /** 校验日期区间 */
    @ApiModelProperty("校验日期区间")
    private Integer checkDays;
    /** 号码间隔合理区间 */
    @ApiModelProperty("号码间隔合理区间")
    private Integer checkStep;
    /** 校验范围 */
    @ApiModelProperty("校验范围")
    private String checkRange;

    /**
     * 配置主表
     */
    private AccReimSettingPayload accReimSettingPayload;
}
