package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Getter
@Setter
public class AccReimSettingPayload extends TwCommonPayload  implements Serializable {
    /** 规则名称 */
    @ApiModelProperty("规则名称")
    private String ruleName;
    /** 状态:1 有效；0 无效 */
    @ApiModelProperty("状态:1 有效；0 无效")
    private Integer effective;
    /** 报销单据类型,udc:ACC:REIM_PROC_KEY */
    @ApiModelProperty("报销单据类型,udc:ACC:REIM_PROC_KEY")
    private String reimDocType;
    /** 核算项目 */
    @ApiModelProperty("核算项目")
    private String busAccItemId;
    /** 适用公司 */
    @ApiModelProperty("适用公司")
    private String expenseCompany;
    /** 适用范围 */
    @ApiModelProperty("适用范围")
    private String applicationScope;
    /** 适用资源 */
    @ApiModelProperty("适用资源")
    private String applicationSource;
    /** 例外人员 */
    @ApiModelProperty("例外人员")
    private String whiteList;
    /** 提醒等级（0警告，1报错） */
    @ApiModelProperty("提醒等级（0警告，1报错）")
    private Integer remindLevel;
    /** 是否执行规则 0 不执行 1执行 */
    @ApiModelProperty("是否执行规则 0 不执行 1执行")
    private Integer executeFlag;
    /** 是否高亮 0 不高亮 1高亮 */
    @ApiModelProperty("是否高亮 0 不高亮 1高亮")
    private Integer highlightFlag;
    /** 高亮颜色 */
    @ApiModelProperty("高亮颜色")
    private String highlightColor;
    /** 提醒文本 */
    @ApiModelProperty("提醒文本")
    private String remindText;
    /** 报错警告文本 */
    @ApiModelProperty("报错警告文本")
    private String errorText;

    /**
     * 报销配置类型
     */
    private String reimSettingType;

    /**
     * 具体的报销配置id
     */
    private Long specificReimSettingId;
}
