package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 预算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccBudgetItemQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 模板id 精确
     */
    @ApiModelProperty("模板id")
    private Long tmplId;
    /**
     * 预算编码 模糊
     */
    @ApiModelProperty("预算编码")
    private String budgetCode;
    /**
     * 预算名称 模糊
     */
    @ApiModelProperty("预算名称")
    private String budgetName;
    /**
     * 上级id 精确
     */
    @ApiModelProperty("上级id")
    private Long parentId;
    /**
     * 上级编号 精确
     */
    @ApiModelProperty("上级编号")
    private String parentCode;
    /**
     * 科目状态 精确
     */
    @ApiModelProperty("科目状态")
    private String budgetStatus;
    /**
     * 级别 精确
     */
    @ApiModelProperty("级别")
    private Integer budgetLevel;
    /**
     * 汇总科目（0：否，1：是） 精确
     */
    @ApiModelProperty("汇总科目（0：否，1：是）")
    private Integer sumFlag;
    /**
     * 明细账 精确
     */
    @ApiModelProperty("明细账")
    private String dtlAcc;
    /**
     * 处理码 精确
     */
    @ApiModelProperty("处理码")
    private String procCode;
    /**
     * 子账标记 精确
     */
    @ApiModelProperty("子账标记")
    private Integer ledgerFlag;
    /**
     * 子账类型 精确
     */
    @ApiModelProperty("子账类型")
    private String ledgerType;
    /**
     * 大类 精确
     */
    @ApiModelProperty("大类")
    private String budgetType1;
    /**
     * 明细类1 精确
     */
    @ApiModelProperty("明细类1")
    private String budgetType2;
    /**
     * 明细类2 模糊
     */
    @ApiModelProperty("明细类2")
    private String budgetType3;
    /**
     * 可配置字段1 模糊
     */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /**
     * 可配置字段2 模糊
     */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /**
     * 可配置字段3 模糊
     */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /**
     * 可配置字段4 模糊
     */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /**
     * 可配置字段5 模糊
     */
    @ApiModelProperty("可配置字段5")
    private String extStr5;

    /**
     * 模板：0 数据：1
     */
    private String downloadType;
}
