package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 报销逾期打折表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Getter
@Setter
public class AccReimSettingOverdueDiscuntQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 报销逾期规则配置主表id 精确 */
    @ApiModelProperty("报销逾期规则配置主表id")
    private Long reimSettingOverdueId;
    /** 日期区间开始（包含） 精确 */
    @ApiModelProperty("日期区间开始（包含）")
    private Integer minDays;
    /** 日期区间结束（不包含） 精确 */
    @ApiModelProperty("日期区间结束（不包含）")
    private Integer maxDays;
    /** 折扣（0~10） 精确 */
    @ApiModelProperty("折扣（0~10）")
    private BigDecimal invLimit;
}
