package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 报销金额来源记录管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Getter
@Setter
public class AccReimSourceRecordQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 报销主表ID 精确
     */
    @ApiModelProperty("报销主表ID")
    private Long reimId;
    /**
     * 报销明细ID 精确
     */
    @ApiModelProperty("报销明细ID")
    private Long reimDtlId;
    /**
     * 报销规则ID 精确
     */
    @ApiModelProperty("报销规则ID")
    private Long ruleId;
    /**
     * 报销内容详情(JSON) 精确
     */
    @ApiModelProperty("报销内容详情(JSON)")
    private String content;

}
