package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBudgetItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBudgetItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 预算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
public interface AccBudgetItemService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccBudgetItemVO}>
     */
    PagingVO<AccBudgetItemVO> queryPaging(AccBudgetItemQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccBudgetItemVO}>
     */
    List<AccBudgetItemVO> queryListDynamic(AccBudgetItemQuery query);


    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccBudgetItemVO}
     */
    AccBudgetItemVO queryByKey(Long key);

    /**
     * 通过编号查询
     *
     * @param code 编号
     * @return {@link AccBudgetItemVO}
     */
    AccBudgetItemVO queryByCode(String code);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccBudgetItemVO}
     */
    AccBudgetItemVO insert(AccBudgetItemPayload payload);


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccBudgetItemPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量导出excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadPlus(HttpServletResponse response, AccBudgetItemQuery query);

    /**
     * 批量立项导入excel
     *
     * @param file 请求响应
     */
    boolean batchImport(MultipartFile file);
}
