package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailMealPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimDetailMealQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailMealVO;

import java.util.List;

/**
 * 报销明细餐费记录
 *
 * @author zoey
 * @date 2024-06-12
 */
public interface AccReimDetailMealService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimDetailMealVO}>
     */
    PagingVO<AccReimDetailMealVO> queryPaging(AccReimDetailMealQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimDetailMealVO}>
     */
    List<AccReimDetailMealVO> queryListDynamic(AccReimDetailMealQuery query);


    /**
     * 初始化餐补明细数据查询
     *
     * @param query
     * @return
     */
    List<AccReimDetailMealVO> queryListInit(AccReimDetailMealQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimDetailMealVO}
     */
    AccReimDetailMealVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimDetailMealVO}
     */
    AccReimDetailMealVO insert(AccReimDetailMealPayload payload);


    List<AccReimDetailMealVO> insertList(List<AccReimDetailMealPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimDetailMealVO}
     */
    AccReimDetailMealVO update(AccReimDetailMealPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimDetailMealPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
