package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimRuleVO;

import java.util.List;
import java.util.Map;

/**
 * 报销规则管理
 *
 * @author sunxw
 * @date 2023-12-03
 */
public interface AccReimRuleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimRuleVO}>
     */
    PagingVO<AccReimRuleVO> queryPaging(AccReimRuleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimRuleVO}>
     */
    List<AccReimRuleVO> queryListDynamic(AccReimRuleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimRuleVO}
     */
    AccReimRuleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimRuleVO}
     */
    AccReimRuleVO insert(AccReimRulePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimRuleVO}
     */
    AccReimRuleVO update(AccReimRulePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimRulePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 报销规则校验
     *
     * @param payload
     * @return
     */
    List<Map<String, String>> reimRuleCheck(AccReimPayload payload);

}
