package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverdueDiscuntPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueDiscuntQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueDiscuntVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 报销逾期打折表
 *
 * @author zoey
 * @date 2024-04-08
 */
public interface AccReimSettingOverdueDiscuntService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingOverdueDiscuntVO}>
     */
    PagingVO<AccReimSettingOverdueDiscuntVO> queryPaging(AccReimSettingOverdueDiscuntQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingOverdueDiscuntVO}>
     */
    List<AccReimSettingOverdueDiscuntVO> queryListDynamic(AccReimSettingOverdueDiscuntQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingOverdueDiscuntVO}
     */
    AccReimSettingOverdueDiscuntVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingOverdueDiscuntVO}
     */
    AccReimSettingOverdueDiscuntVO insert(AccReimSettingOverdueDiscuntPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingOverdueDiscuntVO}
     */
    AccReimSettingOverdueDiscuntVO update(AccReimSettingOverdueDiscuntPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingOverdueDiscuntPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
