package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceConfigVO;

import java.util.List;

/**
 * 报销金额来源配置管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
public interface AccReimSourceConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSourceConfigVO}>
     */
    PagingVO<AccReimSourceConfigVO> queryPaging(AccReimSourceConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSourceConfigVO}>
     */
    List<AccReimSourceConfigVO> queryListDynamic(AccReimSourceConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSourceConfigVO}
     */
    AccReimSourceConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSourceConfigVO}
     */
    AccReimSourceConfigVO insert(AccReimSourceConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSourceConfigVO}
     */
    AccReimSourceConfigVO update(AccReimSourceConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSourceConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
