package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTripStdPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTripStdQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTripStdVO;

import java.util.List;

/**
 * 差旅报销额度管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
public interface AccReimTripStdService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimTripStdVO}>
     */
    PagingVO<AccReimTripStdVO> queryPaging(AccReimTripStdQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimTripStdVO}>
     */
    List<AccReimTripStdVO> queryListDynamic(AccReimTripStdQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimTripStdVO}
     */
    AccReimTripStdVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimTripStdVO}
     */
    AccReimTripStdVO insert(AccReimTripStdPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimTripStdVO}
     */
    AccReimTripStdVO update(AccReimTripStdPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimTripStdPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
