package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;

import java.util.List;

/**
 * 科目模板管理
 *
 * @author carl
 * @date 2023-09-25
 */
public interface AccSubjectTemplateService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccSubjectTemplateVO}>
     */
    PagingVO<AccSubjectTemplateVO> queryPaging(AccSubjectTemplateQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccSubjectTemplateVO}>
     */
    List<AccSubjectTemplateVO> queryListDynamic(AccSubjectTemplateQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccSubjectTemplateVO}
     */
    AccSubjectTemplateVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccSubjectTemplateVO}
     */
    AccSubjectTemplateVO insert(AccSubjectTemplatePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccSubjectTemplateVO}
     */
    AccSubjectTemplateVO update(AccSubjectTemplatePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccSubjectTemplatePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 修改模板状态
     *
     * @param keys 主键集合
     */
    void updateStatus(List<Long> keys, String status);

    /**
     * 逻辑删除明细
     *
     * @param keys 主键集合
     */
    void deleteSoftDetail(List<Long> keys);


    /**
     * 批量新增明细
     *
     * @param payloads 单据数据
     * @return {@link AccSubjectTemplateDetailVO}
     */
    List<AccSubjectTemplateDetailVO> bacthInsert(List<AccSubjectTemplateDetailPayload> payloads);


    /**
     * 分页列表明细
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccSubjectTemplateDetailVO}>
     */
    PagingVO<AccSubjectTemplateDetailVO> queryPagingDetail(AccSubjectTemplateDetailQuery query);


    /**
     * 根据模板id查询预算项目列表
     *
     * @param tmplId 条件参数
     * @return {@link List}<{@link AccSubjectTemplateVO}>
     */
    List<AccBudgetItemVO> queryBudgetItemList(Long tmplId);

}
