package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;


/**
 * 报销科目配置管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
@Getter
@Setter
public class AccReimBusItemConfigVO extends BaseViewModel implements Serializable {
    /**
     * 报销单据类型
     */
    @ApiModelProperty("报销单据类型")
    private String reimDocType;
    @UdcName(udcName = "ACC:REIM_PROC_KEY", codePropName = "reimDocType")
    private String reimDocTypeName;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeName;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String extString1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String extString2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String extString3;

    @ApiModelProperty("核算项目集合")
    private List<AccBusinessItemVO> busItemVolist;

}
