package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;


/**
  * 报销配置连号规则配置
  *
  * @author zoey
  * @date 2024-04-16
  */
@Getter
@Setter
public class AccReimSettingContinuousVO extends BaseViewModel implements Serializable {
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("发票类型Desc")
    @UdcName(udcName = "INV:INPUT_INV_TYPE", codePropName = "invoiceType")
    private String invoiceTypeDesc;
    /** 校验日期区间 */
    @ApiModelProperty("校验日期区间")
    private Integer checkDays;
    /** 号码间隔合理区间 */
    @ApiModelProperty("号码间隔合理区间")
    private Integer checkStep;
    /** 校验范围: ACC:INVOICE_CHECK_RANGE */
    @ApiModelProperty("校验范围")
    private String checkRange;
    @ApiModelProperty("校验范围")
    @UdcName(udcName = "ACC:INVOICE_CHECK_RANGE", codePropName = "checkRange")
    private String checkRangeDesc;

    /**
     * 连号发票列表
     */
    private String continuousInvoiceNos;

    /**
     * 配置主表
     */
    private AccReimSettingVO accReimSettingVO;
}
