package com.elitesland.tw.tw5.api.prd.adm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 特殊费用申请明细管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Getter
@Setter
public class AdmFeeApplyDetailQuery extends TwQueryParam implements Serializable {

    /**
     * 申请单id 精确
     */
    @ApiModelProperty("申请单id")
    private Long applyId;
    /**
     * 序号 精确
     */
    @ApiModelProperty("序号")
    private BigDecimal lineNo;
    /**
     * 科目id 精确
     */
    @ApiModelProperty("科目id")
    private Long accId;
    /**
     * 申请金额 精确
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmt;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 税率 精确
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额 精确
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 费用说明 精确
     */
    @ApiModelProperty("费用说明")
    private String feeDesc;
}
