package com.elitesland.tw.tw5.api.prd.adm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketDataPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmTripTicketVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 行政订票管理
 *
 * @author carl
 * @date 2023-10-30
 */
public interface AdmTripTicketService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AdmTripTicketVO}>
     */
    PagingVO<AdmTripTicketVO> queryPaging(AdmTripTicketQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AdmTripTicketVO}>
     */
    List<AdmTripTicketVO> queryListDynamic(AdmTripTicketQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AdmTripTicketVO}
     */
    AdmTripTicketVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AdmTripTicketVO}
     */
    AdmTripTicketVO insertOrUpdate(AdmTripTicketPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AdmTripTicketVO}
     */
    AdmTripTicketVO update(AdmTripTicketPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AdmTripTicketPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增或修改
     *
     * @param payload 单据数据
     */
    List<AdmTripTicketVO> bacthInsert(AdmTripTicketDataPayload payload);


    void exportList(AdmTripTicketQuery query, HttpServletResponse response) throws IOException;
}
