package com.elitesland.tw.tw5.api.prd.administration.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
    import java.time.LocalDate;
import java.util.List;

/**
 * 资质证照
 *
 * @author wangly
 * @date 2023-09-20
 */
@Getter
@Setter
public class CertificationLicenseQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 证件类型 udc[COM:LICENSE_TYPE] 精确 */
    @ApiModelProperty("证件类型 udc[COM:LICENSE_TYPE]")
    private String licenseType;
    /** 证照名称 精确 */
    @ApiModelProperty("证照名称")
    private String licenseName;
    /** 时间类型 udc[COM:TIME_TYPE] 精确 */
    @ApiModelProperty("时间类型 udc[COM:TIME_TYPE]")
    private String timeType;
    /** 有效日期起 精确 */
    @ApiModelProperty("有效日期起")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validDateStart;
    /** 有效日期止 精确 */
    @ApiModelProperty("有效日期止")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validDateEnd;
    /** 附件 精确 */
    @ApiModelProperty("附件")
    private String fileCode;
    /** 证照来源 精确 */
    @ApiModelProperty("证照来源")
    private String licenseSource;
    /** 证照描述 精确 */
    @ApiModelProperty("证照描述")
    private String licenseDesc;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 精确 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 精确 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
