package com.elitesland.tw.tw5.api.prd.borrow.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowMoneyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 借款管理
 *
 * @author wangly
 * @date 2024-07-15
 */
public interface BorrowMoneyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BorrowMoneyVO}>
     */
    PagingVO<BorrowMoneyVO> queryPaging(BorrowMoneyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BorrowMoneyVO}>
     */
    List<BorrowMoneyVO> queryListDynamic(BorrowMoneyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BorrowMoneyVO}
     */
    BorrowMoneyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BorrowMoneyVO}
     */
    BorrowMoneyVO insert(BorrowMoneyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BorrowMoneyVO}
     */
    BorrowMoneyVO update(BorrowMoneyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BorrowMoneyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 更新借款单据状态
     *
     * @param keys 主键集合
     */
    void updateBorrowStatus(List<Long> keys,String status);

    /**
     * 解绑借款数据
     *
     * @param reimId 报销单id
     * @return {@link long}
     */
    void relateBorrowData(Long reimId);

    /**
     * 现金核销接口
     *
     * @param key 借款单id
     */
    void cashWriteOff(Long key, BigDecimal writeOffAmt);
}
