package com.elitesland.tw.tw5.api.prd.borrow.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 出让申请
 *
 * @author wangly
 * @date 2024-07-15
 */
@Getter
@Setter
public class TransferApplyVO extends BaseViewModel implements Serializable {
    /**
     * 借款ID
     */
    @ApiModelProperty("借款ID")
    private Long borrowId;
    /**
     * 出让名称
     */
    @ApiModelProperty("出让名称")
    private String transferName;
    /**
     * 出让人ID
     */
    @ApiModelProperty("出让人ID")
    private Long transferUserId;
    /**
     * 出让人ID
     */
    @ApiModelProperty("出让人ID")
    @UdcName(udcName = "USER", codePropName = "transferUserId")
    private String transferUserName;
    /**
     * 出让日期
     */
    @ApiModelProperty("出让日期")
    private LocalDate transferDate;
    /**
     * 出让人所属bu
     */
    @ApiModelProperty("出让人所属bu")
    private Long transferBuId;
    /**
     * 出让人所属bu
     */
    @ApiModelProperty("出让人所属bu")
    @UdcName(udcName = "BU", codePropName = "transferBuId")
    private String transferBuName;
    /**
     * 受让人ID
     */
    @ApiModelProperty("受让人ID")
    private Long receiveUserId;
    /**
     * 受让人名称
     */
    @ApiModelProperty("受让人ID")
    @UdcName(udcName = "USER", codePropName = "receiveUserId")
    private String receiveUserName;
    /**
     * 受让人所属bu
     */
    @ApiModelProperty("受让人所属bu")
    private Long receiveBuId;
    /**
     * 受让人所属bu
     */
    @ApiModelProperty("受让人所属bu")
    @UdcName(udcName = "BU", codePropName = "receiveBuId")
    private String receiveBuName;
    /**
     * 出让原因
     */
    @ApiModelProperty("出让原因")
    private String transferReason;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("流程审批状态")
    @UdcName(udcName = "appr_status",codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;

    /**
     * 受让人一级部门
     */
    @ApiModelProperty("受让人一级部门")
    private Long receiveFirstBuId = 0L;

    /**
     * 借款详情
     */
    @ApiModelProperty("借款详情")
    private BorrowMoneyVO borrowMoneyVO;

    /**
     * 借款核销列表
     */
    @ApiModelProperty("借款核销列表")
    private List<BorrowWriteOffVO> borrowWriteOffList;

}
