package com.elitesland.tw.tw5.api.prd.budget.vo;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Getter
@Setter
@ToString
public class BudgetCommonVO implements Serializable {

    /**
     * 事由类型（合同项目，BU项目，商机项目）
     */
    private String reasonType;
    /**
     * 事由id
     */
    private Long reasonId;

    /**
     * 合同id
     */
    private Long contractId;
    /**
     * 占用当量
     */
    private BigDecimal occupyEqva = BigDecimal.ZERO;

    /**
     * 已使用当量
     */
    private BigDecimal usedEqva = BigDecimal.ZERO;
    /**
     * 可用当量
     */
    private BigDecimal availableEqva = BigDecimal.ZERO;
    /**
     * 占用金额
     */
    private BigDecimal occupyAmt = BigDecimal.ZERO;
    /**
     * 已使用金额
     */
    private BigDecimal usedAmt = BigDecimal.ZERO;
    /**
     * 可用金额
     */
    private BigDecimal availableAmt = BigDecimal.ZERO;
    /**
     * 活动占用当量
     */
    private Map<Long, BigDecimal> actOccupyEqvaMap = new HashMap<>();
    /**
     * 活动使用当量
     */
    private Map<Long, BigDecimal> actUsedEqvaMap = new HashMap<>();
    /**
     * 科目占用费用金额
     */
    private Map<Long, BigDecimal> accOccupyAmtMap = new HashMap<>();
    /**
     * 科目使用费用金额
     */
    private Map<Long, BigDecimal> accUsedAmtMap = new HashMap<>();

}
