package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
public class CalTaskSettleQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 结算单号 精确
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态 精确
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    /**
     * 结算状态 精确
     */
    @ApiModelProperty("结算状态")
    private List<String> settleStatusList;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id 精确
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 结算类型（任务包总价结算，任务包单价结算） 精确
     */
    @ApiModelProperty("结算类型（任务包总价结算，任务包单价结算）")
    private String settleType;
    /**
     * 结算日期 精确
     */
    @ApiModelProperty("结算日期")
    private LocalDate settleDate;
    /**
     * 结算开始日期 精确
     */
    @ApiModelProperty("结算开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleStartDate;
    /**
     * 结算结束日期 精确
     */
    @ApiModelProperty("结算结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleEndDate;
    /**
     * 财务期间id 精确
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 验收方式 精确
     */
    @ApiModelProperty("验收方式")
    private String acceptMethod;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 任务包id 精确
     */
    @ApiModelProperty("任务包id")
    private Long taskId;
    /**
     * 支出bu_id 精确
     */
    @ApiModelProperty("支出bu_id")
    private Long expenseBuId;
    /**
     * 收入资源id 精确
     */
    @ApiModelProperty("收入资源id")
    private Long incomeResId;
    /**
     * 收入bu_id 精确
     */
    @ApiModelProperty("收入bu_id")
    private Long resBuId;
    /**
     * 当量系数 精确
     */
    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;
    /**
     * 当量工资(收入单价) 精确
     */
    @ApiModelProperty("当量工资(收入单价)")
    private BigDecimal eqvaSalary;
    /**
     * 申请结算当量数 精确
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额 精确
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 结算单价 精确
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 实际结算当量数 精确
     */
    @ApiModelProperty("实际结算当量数")
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额 精确
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 质保金比例 精确
     */
    @ApiModelProperty("质保金比例")
    private BigDecimal guaranteeRate;
    /**
     * 质保当量 精确
     */
    @ApiModelProperty("质保当量")
    private BigDecimal graranteeEqva;
    /**
     * 申请人资源id 精确
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    /**
     * 评价状态 精确
     */
    @ApiModelProperty("评价状态")
    private String evalStatus;
    /**
     * 累计提现当量 精确
     */
    @ApiModelProperty("累计提现当量")
    private BigDecimal withdrawEqva;
    /**
     * bu累计提现当量 精确
     */
    @ApiModelProperty("bu累计提现当量")
    private BigDecimal buWithdrawEqva;

    /**
     * 查询类型：（0或空，标准查询，1：提现查询）
     */
    @ApiModelProperty("查询类型：（0或空，标准查询，1：提现查询）")
    private Integer searchType;
    /**
     * 可用数量=批准结算当量-已提现当量-冻结当量
     */
    @ApiModelProperty("可用数量")
    private BigDecimal avalQty;
    /**
     * 提现或解冻标识：（0：未操作，1：解冻中，2：提现中）
     */
    @ApiModelProperty("提现或解冻标识")
    private Integer operateFlag;
}
