package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 泛用当量结算单管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
public class CalWideSettleQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 结算单号 精确
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态 精确
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id 精确
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 结算类型（项目立项，项目结项。。。） 精确
     */
    @ApiModelProperty("结算类型（项目立项，项目结项。。。）")
    private String settleType;
    /**
     * 结算日期 精确
     */
    @ApiModelProperty("结算日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleDate;
    /**
     * 结算开始日期 精确
     */
    @ApiModelProperty("结算开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleStartDate;
    /**
     * 结算结束日期 精确
     */
    @ApiModelProperty("结算结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleEndDate;
    /**
     * 财务期间id 精确
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 支出核算主题类型 精确
     */
    @ApiModelProperty("支出核算主题类型")
    private String fromSourceType;
    /**
     * 支出核算主题id 精确
     */
    @ApiModelProperty("支出核算主题id")
    private Long fromSourceId;
    /**
     * 收入核算主题类型 精确
     */
    @ApiModelProperty("收入核算主题类型")
    private String toSourceType;
    /**
     * 收入核算主题id 精确
     */
    @ApiModelProperty("收入核算主题id")
    private Long toSourceId;
    /**
     * 申请结算当量数 精确
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额 精确
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 结算单价 精确
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 交易凭证文件code 精确
     */
    @ApiModelProperty("交易凭证文件code")
    private String fileCodes;
}
