package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaCostPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaCostQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaCostVO;

import java.util.List;

/**
 * 当量成本配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
public interface CalEqvaCostService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalEqvaCostVO}>
     */
    PagingVO<CalEqvaCostVO> queryPaging(CalEqvaCostQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalEqvaCostVO}>
     */
    List<CalEqvaCostVO> queryListDynamic(CalEqvaCostQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalEqvaCostVO}
     */
    CalEqvaCostVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link CalEqvaCostVO}
     */
    CalEqvaCostVO insertOrUpdate(CalEqvaCostPayload payload);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 精准匹配查询-获取价格
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalEqvaCostVO}>
     */
    CalEqvaCostVO getEqvaCostPlus(CalEqvaCostQuery query);
}
