package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalNormSettleVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalWideSettleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 核算-数据处理中间层
 *
 * @author carl
 * @date 2023-11-13
 */
public interface CalResourceService {

    /**
     * 获取结算价格
     *
     * @param query
     * @return
     */
    BigDecimal querySettlePrice(CalResourcePriceQuery query);

    /**
     * 获取任务包资源收入价格
     *
     * @param query
     * @return
     */
    BigDecimal queryIncomePrice(CalResourcePriceQuery query);

    /**
     * 任务结算流水处理
     */
    void taskSettleTurnover(List<CalTaskSettleVO> settleVOs);

    /**
     * 结算单冻结当量解冻
     *
     * @param settleVOs
     */
    void unFreezeTaskSettle(List<CalTaskSettleVO> settleVOs);

    /**
     * 任务结算提现流水处理
     */
    void taskSettleWithdrawTurnover(CalTaskSettleWithdrawPayload payload);

    /**
     * 泛用结算单流水处理
     * （结算类型：
     * 项目立项
     * 项目结项
     * 当量提现
     * 手工调整）
     */
    void wideSettleTurnover(CalWideSettleVO calWideSettleVO);

    /**
     * 泛用金额结算单流水处理
     *
     * @param calNormSettleVO
     * @param normType        1:过账，0：取消过账
     */
    void amountSettleTurnover(CalNormSettleVO calNormSettleVO, Integer normType);

    /**
     * 泛用金额结算单批量流水处理
     *
     * @param calNormSettleVOS
     * @param calAccountVOS
     */
    void amountBatchSettleTurnover(List<CalNormSettleVO> calNormSettleVOS, List<CalAccountVO> calAccountVOS);

//    /**
//     * 生成资源冻结或解冻记录
//     *
//     * @param settleVO     任务结算单
//     * @param calAccountVO 结算账户
//     * @param isAdd        冻结：true,解冻：false
//     * @return
//     */
//    void getTaskFreezePayload(CalTaskSettleVO settleVO, CalAccountVO calAccountVO, Boolean isAdd);

    /**
     * 获取和校验账户数据
     *
     * @param auType
     * @param auId
     * @return
     */
    CalAccountVO queryAccount(String auType, Long auId);

    /**
     * 校验账户
     *
     * @return 结果
     */
    void checkAccount(CalAccountVO vo);

    /**
     * 账户派发校验
     *
     * @param distributeVO
     */
    void checkDistributeAccount(PmsDistributeVO distributeVO);

    /**
     * 重置账户数据
     *
     * @param operType 操作类型 空：全部数据（慎用），1：处理正数数据，-1：处理负数数据
     * @param remark   操作说明
     */
    void resetAccount(String auType, String operType, String remark);
}
