package com.elitesland.tw.tw5.api.prd.cal.vo;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@SearchBean(
        tables = "cal_task_settle cts ",
        where = "cts.delete_flag = 0",
        autoMapTo = "cts"
)
@Getter
@Setter
@ToString
public class CalTaskSettleVO extends BaseViewModel implements Serializable {

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    @UdcName(udcName = "CAL:SETTLE:STATUS", codePropName = "settleStatus")
    @DbIgnore
    private String settleStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 结算类型（任务包总价结算，任务包单价结算）
     */
    @ApiModelProperty("结算类型（任务包总价结算，任务包单价结算）")
    private String settleType;
    @UdcName(udcName = "CAL:SETTLE:TASK:TYPE", codePropName = "settleType")
    @DbIgnore
    private String settleTypeDesc;
    /**
     * 结算日期
     */
    @ApiModelProperty("结算日期")
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 验收方式
     */
    @ApiModelProperty("验收方式")
    private String acceptMethod;
    /**
     * 事由类型 01 项目 02 商机
     */
    @ApiModelProperty("事由类型 01 项目 02 商机")
    private String reasonType;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 任务包id
     */
    @ApiModelProperty("任务包id")
    private Long taskId;
    /**
     * 项目名称（冗余）
     */
    @ApiModelProperty("项目名称（冗余）")
    private String projName;
    /**
     * 任务包名称（冗余）
     */
    @ApiModelProperty("任务包名称（冗余）")
    private String taskName;
    /**
     * 支出bu_id
     */
    @ApiModelProperty("支出bu_id")
    private Long expenseBuId;
    @UdcName(udcName = "BU", codePropName = "expenseBuId")
    @DbIgnore
    private String expenseBuName;
    /**
     * 收入资源id
     */
    @ApiModelProperty("收入资源id")
    private Long incomeResId;
    @UdcName(udcName = "USER", codePropName = "incomeResId")
    @DbIgnore
    private String incomeResName;
    /**
     * 收入bu_id
     */
    @ApiModelProperty("收入bu_id")
    private Long resBuId;
    @UdcName(udcName = "BU", codePropName = "resBuId")
    @DbIgnore
    private String resBuName;
    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;
    /**
     * 当量工资(收入单价)
     */
    @ApiModelProperty("当量工资(收入单价)")
    private BigDecimal eqvaSalary;
    /**
     * 申请结算当量数
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 结算单价
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 实际结算当量数
     */
    @ApiModelProperty("实际结算当量数")
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 申请收入总额
     */
    @ApiModelProperty("申请收入总额")
    private BigDecimal applyIncomeAmt;
    /**
     * 实际收入总额
     */
    @ApiModelProperty("实际收入总额")
    private BigDecimal approveIncomeAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 质保金比例
     */
    @ApiModelProperty("质保金比例")
    private BigDecimal guaranteeRate;
    /**
     * 质保当量
     */
    @ApiModelProperty("质保当量")
    private BigDecimal graranteeEqva;
    /**
     * 质保总额（冻结金额）
     */
    @ApiModelProperty("质保总额（冻结金额）")
    private BigDecimal graranteeAmt;
    /**
     * 申请人资源id
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    @DbIgnore
    private String applyResName;
    /**
     * 发包资源id
     */
    @ApiModelProperty("发包资源id")
    private Long disterResId;
    /**
     * 评价状态
     */
    @ApiModelProperty("评价状态")
    private String evalStatus;
    /**
     * 累计提现当量
     */
    @ApiModelProperty("累计提现当量")
    private BigDecimal withdrawEqva;
    /**
     * bu累计提现当量
     */
    @ApiModelProperty("bu累计提现当量")
    private BigDecimal buWithdrawEqva;
    /**
     * 文件code
     */
    @ApiModelProperty("文件code")
    private String fileCodes;
    /**
     * 文件
     */
    @ApiModelProperty("文件")
    @DbIgnore
    private Object fileDatas;
    /**
     * 结算单明细
     */
    @ApiModelProperty("结算单明细")
    @DbIgnore
    private List<CalTaskSettleDetailVO> settleDetailVOs;
    /**
     * 可用当量=批准结算当量-已提现当量-冻结当量
     */
    @ApiModelProperty("可用当量")
    private BigDecimal avalQty;
    /**
     * 可用金额=可用当量*收入单价
     */
    @ApiModelProperty("可用金额")
    @DbIgnore
    private BigDecimal avalAmt;
    /**
     * 提现或解冻标识：（0：未操作，1：解冻中，2：提现中）
     */
    @ApiModelProperty("提现或解冻标识")
    private Integer operateFlag;


    public void copy(CalTaskSettleVO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
