package com.elitesland.tw.tw5.api.prd.copartner.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@Getter
@Setter
public class PerformanceReadmeConfigUserQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 配置主键 精确
     */
    @ApiModelProperty("配置主键")
    private Long configId;
    /**
     * 员工主键 精确
     */
    @ApiModelProperty("员工主键")
    private Long userId;
    /**
     * buid 精确
     */
    @ApiModelProperty("buid")
    private Long buId;

    /**
     * 考核周期 精确
     */
    @ApiModelProperty("考核周期")
    private String configCycle;
    /**
     * 发起人
     */
    @ApiModelProperty("发起人")
    private Long applyUserId;
    /**
     * 状态 精确
     */
    @ApiModelProperty("状态")
    private Integer applyStatus;
    /**
     * 名称 模糊
     */
    @ApiModelProperty("名称")
    private String configUserName;
    /**
     * 审批名称 模糊
     */
    @ApiModelProperty("审批名称")
    private String procInstName;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    /**
     * 流程id 精确
     */
    @ApiModelProperty("流程id")
    private String procInstId;
}
