package com.elitesland.tw.tw5.api.prd.copartner.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@SearchBean(
        tables = "performance_readme_config_user prcu " +
                "left join performance_readme_config prc on prcu.config_id = prc.id ",
        where = "prcu.delete_flag = 0 and prc.delete_flag = 0 ",
        groupBy = ":groupBy:",
        autoMapTo = "prcu"
)
@Getter
@Setter
public class PerformanceReadmeConfigUserVO extends BaseViewModel implements Serializable {
    /**
     * 配置主键
     */
    @ApiModelProperty("配置主键")
    private Long configId;
    /**
     * 汇报人员工主键
     */
    @ApiModelProperty("汇报人员工主键")
    private Long userId;
    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "userId")
    private String userName;
    /**
     * 发起人
     */
    @DbField(mapTo = "prc")
    @ApiModelProperty("发起人")
    private Long applyUserId;
    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;

    @DbField(mapTo = "prc")
    @ApiModelProperty("考核周期")
    private String configCycle;
    @DbIgnore
    @UdcName(udcName = "org:employee:preCycle", codePropName = "configCycle")
    private String configCycleDesc;
    /**
     * 开始日期
     */
    @DbField(mapTo = "prc")
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @DbField(mapTo = "prc")
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * buid 精确
     */
    @ApiModelProperty("buid")
    private Long buId;
    @DbIgnore
    @UdcName(udcName = "BU", codePropName = "buId")
    private String buName;
    /**
     * 状态：0未开始或流程中，1已完成
     */
    @ApiModelProperty("状态：0未开始或流程中，1已完成")
    private Integer applyStatus;
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String configUserName;
    /**
     * 审批名称
     */
    @ApiModelProperty("审批名称")
    private String procInstName;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    @DbIgnore
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 流程id
     */
    @ApiModelProperty("流程id")
    private String procInstId;

    /**
     * 合伙人绩效自述明细
     */
    @DbIgnore
    @ApiModelProperty("合伙人绩效自述明细")
    private List<PerformanceReadmeUserDetailVO> performanceReadmeUserDetailVOs;
}
