package com.elitesland.tw.tw5.api.prd.copartner.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 合伙人绩效自述配置
 *
 * @author carl
 * @date 2024-06-24
 */
@Getter
@Setter
public class PerformanceReadmeConfigVO extends BaseViewModel implements Serializable {
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String configName;
    /**
     * 考核周期
     */
    @ApiModelProperty("考核周期")
    private String configCycle;
    @UdcName(udcName = "org:employee:preCycle", codePropName = "configCycle")
    private String configCycleDesc;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String configStatus;
    /**
     * 发起人
     */
    @ApiModelProperty("发起人")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;
    /**
     * 发起时间
     */
    @ApiModelProperty("发起时间")
    private LocalDateTime applyTime;
    /**
     * 完成时间
     */
    @ApiModelProperty("完成时间")
    private LocalDateTime finishTime;
    /**
     * 考核点维护
     */
    @ApiModelProperty("考核点维护")
    private List<PerformanceReadmeConfigDetailVO> performanceReadmeConfigDetailVOs;
    /**
     * 考核范围
     */
    @ApiModelProperty("考核范围")
    private List<PerformanceReadmeConfigUserVO> performanceReadmeConfigUserVO;
}
