package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/

@Data

public class CrmActPlanPayload extends TwCommonPayload {
    /**
     * 编号
     */
    private String planNo;

    /**
     * 名称
     */
    private String planName;

    /**
     * bu（组织）
     */
    private Long orgId;

    /**
     * 预算年度
     */
    private String planYear;

//    /**
//     * 操作状态 save:保存 submit:提交
//     */
//    private String opeStatus;

    /**
     * 预算总金额
     */
    private BigDecimal budgetMoney;
    /**
     * 预估产出线索
     */
    private Integer leadNum;
    /**
     * 预估产出销售额
     */
    private BigDecimal pipeline;

    /**
     * 状态
     */
    private String planStatus;

    /**
     * 是否是更新操作
     */
    private Integer planChangeFlag;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

}
