package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
@ExcelIgnoreUnannotated
public class CrmCustomerOperationExcel {

    /**
     * 客户表主键
     */
    private Long customerId;

    /**
     * 客户经营编号
     */
    private String custNo;

    /**
     * 类型 udc
     */
    private String custType;
    @UdcName(udcName = "crm:cust_oper:type", codePropName = "custType")
    private String custTypeDesc;

    /**
     * 第三方公司主键：天眼查id or 启信宝id
     */
    private String threeId;

    /**
     * 第三方公司类型：天眼查:TYC or 启信宝:QXB
     */
    private String threeType;

    /**
     * 提交的部门
     */
    @ExcelProperty(index = 2)
    private String excelCommitBuName;

    /**
     * 名称
     */
    @ExcelProperty(index = 3)
    private String custName;

    /**
     * 公司性质 udc[crm:company_nature]
     */
    private String custNature;
    @UdcName(udcName = "crm:company_nature", codePropName = "custNature")
    private String custNatureDesc;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    private String custIndustry;
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "custIndustry")
    @ExcelProperty(index = 6)
    private String custIndustryDesc;

    /**
     * 母公司主键
     */
    private Long parentId;

    /**
     * 母公司名称
     */
    private String parentCompany;

    /**
     * 网址
     */
    private String website;

    /**
     * 座机
     */
    private String landline;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 省
     */
    private String province;

    /**
     * 省名字
     */
    @ExcelProperty(index = 11)
    private String provinceName;

    /**
     * 城市
     */
    private String city;

    /**
     * 城市名字
     */
    @ExcelProperty(index = 12)
    private String cityName;

    /**
     * 区
     */
    private String district;

    /**
     * 地区名称
     */
    @ExcelProperty(index = 13)
    private String districtName;

    /**
     * 地址
     */
    private String custAddress;

    /**
     * 客户级别 udc[crm:cust_oper:cust_grade]
     */
    @ExcelProperty(index = 14)
    private String custGrade;
    @UdcName(udcName = "crm:cust_oper:cust_grade", codePropName = "custGrade")
    private String custGradeDesc;

    /**
     * 销售规模
     */
    private BigDecimal saleScale;
    @ExcelProperty(index = 5)
    private String saleScaleStr;

    /**
     * 行业地位 udc[crm:cust_oper:cust_industry]
     */
    private String industryStand;
    @UdcName(udcName = "crm:cust_oper:cust_industry", codePropName = "industryStand")
    @ExcelProperty(index = 7)
    private String industryStandDesc;

    /**
     * 数字化投入力度 udc[crm:cust_oper:digital]
     */
    private String digitalInvestment;
    @UdcName(udcName = "crm:cust_oper:digital", codePropName = "digitalInvestment")
    @ExcelProperty(index = 8)
    private String digitalInvestmentDesc;

    /**
     * 与公司紧密度 udc[crm:cust_oper:tightness]
     */
    private String companyTightness;
    @UdcName(udcName = "crm:cust_oper:tightness", codePropName = "companyTightness")
    @ExcelProperty(index = 9)
    private String companyTightnessDesc;

    /**
     * 历史合作产出（万元）
     */
    private BigDecimal historyCooOutput;
    @ExcelProperty(index = 10)
    private String historyCooOutputStr;

    /**
     * 销售经营部门
     */
    private Long saleOperBu;
    @UdcName(udcName = "BU", codePropName = "saleOperBu")
    @ExcelProperty(index = 15)
    private String saleOperBuName;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;

    /**
     * 销售经营部负责人
     */
    @UdcName(udcName = "USER", codePropName = "saleOperManagerId")
    @ExcelProperty(index = 16)
    private String saleOperManagerName;

    /**
     * 客户经营部门
     */
    private Long custOperBu;
    @UdcName(udcName = "BU", codePropName = "custOperBu")
    @ExcelProperty(index = 17)
    private String custOperBuName;

    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;

    /**
     * 客户经营部负责人
     */
    @UdcName(udcName = "USER", codePropName = "custOperManagerId")
    @ExcelProperty(index = 18)
    private String custOperManagerName;

    /**
     * 经营策略 udc[crm:cust_oper:strategy]
     */
    private String businessStrategy;
    @UdcName(udcName = "crm:cust_oper:strategy", codePropName = "businessStrategy")
    @ExcelProperty(index = 20)
    private String businessStrategyDesc;

    /**
     * 主营业务 udc[crm:cust_oper:main_business]
     */
    private String mainBusiness;
    @UdcName(udcName = "crm:cust_oper:main_business", codePropName = "mainBusiness")
    private String mainBusinessDesc;

    /**
     * 销售覆盖
     */
    private String saleCover;

    /**
     * 合作形式 udc[crm:cust_oper:coop_type]
     */
    private String coopType;
    @UdcName(udcName = "crm:cust_oper:coop_type", codePropName = "coopType")
    private String coopTypeDesc;

    /**
     * 合作等级
     */
    private String coopLevel;

    /**
     * 渠道经营部门
     */
    private Long channelBu;
    @UdcName(udcName = "BU", codePropName = "channelBu")
    private String channelBuName;

    /**
     * 渠道经营负责人
     */
    private Long channelUserId;
    @UdcName(udcName = "USER", codePropName = "channelUserId")
    private String channelUserName;

    /**
     * 产品负责人
     */
    private Long productUserId;
    @UdcName(udcName = "USER", codePropName = "productUserId")
    private String productUserName;

    /**
     * 生态伙伴业务简述
     */
    private String ecoDescription;

    /**
     * 客户企业业务简述
     */
    @ExcelProperty(index = 4)
    private String custDescription;

    /**
     * 组织及协会简述
     */
    private String orgAssDescription;

    /**
     * 服务负责人
     */
    private Long serviceUserId;

    /**
     * 服务负责人
     */
    @UdcName(udcName = "USER", codePropName = "serviceUserId")
    @ExcelProperty(index = 19)
    private String serviceUserName;

    /**
     * 商务负责人
     */
    private Long businessUserId;

    /**
     * 商务负责人
     */
    @UdcName(udcName = "USER", codePropName = "businessUserId")
    private String businessUserName;

    /**
     * 关怀负责人
     */
    private Long careUserId;

    /**
     * 关怀负责人
     */
    @UdcName(udcName = "USER", codePropName = "careUserId")
    private String careUserName;

    /**
     * 运维售后负责人
     */
    private Long operationUserId;

    /**
     * 运维售后负责人
     */
    @UdcName(udcName = "USER", codePropName = "operationUserId")
    private String operationUserName;

    /**
     * 拓展1
     */
    private String ext1;

    /**
     * 拓展2
     */
    private String ext2;

    /**
     * 拓展3
     */
    private String ext3;

    /**
     * 拓展4
     */
    private String ext4;

    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 导入警告
     */
    private String importWarn;

    /**
     * 导入错误
     */
    private String imoprtError;

    private Long createUserId;

    private String remark;

    private Integer deleteFlag;

}
